#!/bin/bash

NonHeaderLine(){
    grep -v ^Dial
}

NonEmptyLine(){
    grep -v ^$
}

ListCorpusAlice(){
    ls Surrogate/Corpus_Alice_random | grep -e "cleaned-[AB].txt$"
}
INPUT_DIR='Surrogate/Corpus_Alice_random'
OUTPUT_DIR='Surrogate/Corpus_Alice_random'

echo "Running dialign for the 'Agent Charles' corpus"
for f in `ListCorpusAlice`; do
    echo "   ...processing: $f"
    java -jar /home/gdd/git/code-aria/dialign/target/scala-2.11/dialignMeasures.jar \
	-i "$INPUT_DIR/$f" \
	-n \
	> "$OUTPUT_DIR/$f.dynamics.csv"
done
cat $INPUT_DIR/*.dynamics.csv | cut -f 1,3,4,5,7,8,9 | NonHeaderLine | NonEmptyLine > $OUTPUT_DIR/dial-online.csv

ListNegHA(){
    ls Surrogate/Corpus_Negotiation_H-A_random/ | grep "cleaned-[AB].txt$"
}
INPUT_DIR='Surrogate/Corpus_Negotiation_H-A_random'
OUTPUT_DIR='Surrogate/Corpus_Negotiation_H-A_random'

echo "Running dialign for the Negotiation H-A corpus"
for f in `ListNegHA`; do
    echo "   ...processing: $f"
    java -jar /home/gdd/git/code-aria/dialign/target/scala-2.11/dialignMeasures.jar \
	-i "$INPUT_DIR/$f" \
	> "$OUTPUT_DIR/$f.dynamics.csv"
done
cat $INPUT_DIR/*.dynamics.csv | cut -f 1,3,4,5,7,8,9 | NonHeaderLine | NonEmptyLine > $OUTPUT_DIR/dial-online.csv

ListNegHH(){
    ls Surrogate/Corpus_Negotiation_H-H_random/ | grep "Dyad-[AB].txt$"
}
INPUT_DIR='Surrogate/Corpus_Negotiation_H-H_random'
OUTPUT_DIR='Surrogate/Corpus_Negotiation_H-H_random'

echo "Running dialign for the Negotiation H-H corpus"
for f in `ListNegHH`; do
    echo "   ...processing: $f"
    java -jar /home/gdd/git/code-aria/dialign/target/scala-2.11/dialignMeasures.jar \
	-i "$INPUT_DIR/$f" \
	> "$OUTPUT_DIR/$f.dynamics.csv"
done
cat $INPUT_DIR/*.dynamics.csv | cut -f 1,3,4,5,7,8,9 | NonHeaderLine | NonEmptyLine > $OUTPUT_DIR/dial-online.csv
