#!/bin/bash

NonHeaderLine(){
    grep -v ^Dial
}

NonEmptyLine(){
    grep -v ^$
}

ListCorpusAlice(){
    ls Corpus_Alice/ | grep "cleaned.txt$"
}
INPUT_DIR='Corpus_Alice'
OUTPUT_DIR='Corpus_Alice'

echo "Running dialign for the 'Agent Charles' corpus"
for f in `ListCorpusAlice`; do
    echo "   ...processing: $f"
    java -jar /home/gdd/git/code-aria/dialign/target/scala-2.11/dialignMeasures.jar \
	-i "$INPUT_DIR/$f" \
	-n \
	> "$OUTPUT_DIR/$f.dynamics.csv"
done
cat $INPUT_DIR/*.dynamics.csv | cut -f 1,3,4,5,7,8,9 | NonHeaderLine | NonEmptyLine > $OUTPUT_DIR/dial-online.csv

ListNegHA(){
    ls Corpus_Negotiation_H-A/ | grep "cleaned.txt$"
}
INPUT_DIR='Corpus_Negotiation_H-A'
OUTPUT_DIR='Corpus_Negotiation_H-A'

echo "Running dialign for the Negotiation H-A corpus"
for f in `ListNegHA`; do
    echo "   ...processing: $f"
    java -jar /home/gdd/git/code-aria/dialign/target/scala-2.11/dialignMeasures.jar \
	-i "$INPUT_DIR/$f" \
	> "$OUTPUT_DIR/$f.dynamics.csv"
done
cat $INPUT_DIR/*.dynamics.csv | cut -f 1,3,4,5,7,8,9 | NonHeaderLine | NonEmptyLine > $OUTPUT_DIR/dial-online.csv

ListNegHH(){
    ls Corpus_Negotiation_H-H/ | grep "Dyad.txt$"
}
INPUT_DIR='Corpus_Negotiation_H-H'
OUTPUT_DIR='Corpus_Negotiation_H-H'

echo "Running dialign for the Negotiation H-H corpus"
for f in `ListNegHH`; do
    echo "   ...processing: $f"
    java -jar /home/gdd/git/code-aria/dialign/target/scala-2.11/dialignMeasures.jar \
	-i "$INPUT_DIR/$f" \
	> "$OUTPUT_DIR/$f.dynamics.csv"
done
cat $INPUT_DIR/*.dynamics.csv | cut -f 1,3,4,5,7,8,9 | NonHeaderLine | NonEmptyLine > $OUTPUT_DIR/dial-online.csv
