import io
import numpy as np
import collections

from os import listdir
from os.path import isfile, join
import sys


_ROOT = sys.argv[1]

def _is_valid_filename(name):
    return name.endswith('-lexicon.csv')

list_of_files = [join(_ROOT, f) for f in listdir(_ROOT) if isfile(join(_ROOT, f)) and _is_valid_filename(f)]

freqs = []
free_freqs = []
sizes = []
spans = []
primings = []
densities = []

for filename in list_of_files:
    with io.open(filename, 'r') as f:
        is_first_line = True
        for line in f:
            if is_first_line:
                is_first_line = False
            else:
                if len(line.strip()) != 0:
                    content = line.split('\t')
                    freq = int(content[0])
                    free_freq = int(content[1])
                    size = int(content[2])
                    spanning = int(content[5])
                    priming = int(content[6])

                    density = float(freq) / float(spanning)

                    freqs.append(freq)
                    free_freqs.append(free_freq)
                    sizes.append(size)
                    spans.append(spanning)
                    primings.append(priming)
                    densities.append(density)

print('freq{0}free_freq{0}size{0}span{0}priming{0}density'.format('\t'))
for i in range(len(freqs)):
    print('{1}{0}{2}{0}{3}{0}{4}{0}{5}{0}{6}'.format('\t', freqs[i], free_freqs[i], sizes[i], \
                                                     spans[i], primings[i], densities[i]))
