# LOADING THE DATA
dataNegHA <- read.csv2("Corpora/Corpus_Negotiation_H-A/dial-synthesis.csv", header=TRUE, dec=".", sep="\t")
dataNegHASurrogate <- read.csv2("Corpora/Surrogate/Corpus_Negotiation_H-A_random/dial-synthesis.csv", header=TRUE, dec=".", sep="\t")

dataNegHH <- read.csv2("Corpora/Corpus_Negotiation_H-H/dial-synthesis.csv", header=TRUE, dec=".", sep="\t")
dataNegHHSurrogate <- read.csv2("Corpora/Surrogate/Corpus_Negotiation_H-H_random/dial-synthesis.csv", header=TRUE, dec=".", sep="\t")

dataAgentCharles <- read.csv2("Corpora/Corpus_Alice/dial-synthesis.csv", header=TRUE, dec=".", sep="\t")
dataAgentCharlesSurrogate <- read.csv2("Corpora/Surrogate/Corpus_Alice_random/dial-synthesis.csv", header=TRUE, dec=".", sep="\t")

columns <- c('ID', 'num_utterances', 'num_tokens', 
                      'ELS', 'EV', 'ER', 
                      'IE_S1', 'ER_S1', 'tokens_S1', 
                      'IE_S2', 'ER_S2', 'tokens_S2', 
                      'voc_overlap', 'voc_overlap_S1', 'voc_overlap_S2',
                      'ENTR', 'L', 'LMAX',
                      'SELS_S1', 'SEV_S1', 'SER_S1', 'SR_ENTR_S1', 'SR_L_S1', 'SR_LMAX_S1',
                      'SELS_S2', 'SEV_S2', 'SER_S2', 'SR_ENTR_S2', 'SR_L_S2', 'SR_LMAX_S2')

colnames(dataNegHA) <- columns
colnames(dataNegHASurrogate) <- columns
colnames(dataNegHH) <- columns
colnames(dataNegHHSurrogate) <- columns
colnames(dataAgentCharles) <- columns
colnames(dataAgentCharlesSurrogate) <- columns

# Make sure the data are properly loaded
summary(dataNegHA)
summary(dataNegHASurrogate)
summary(dataNegHH)
summary(dataNegHHSurrogate)
summary(dataAgentCharles)
summary(dataAgentCharlesSurrogate)

# OFFLINE STUDY
## A. Charles
wilcox.test(dataAgentCharles$EV, dataAgentCharlesSurrogate$EV, paired=FALSE, correct=TRUE)
wilcox.test(dataAgentCharles$ER, dataAgentCharlesSurrogate$ER, paired=FALSE, correct=TRUE)

wilcox.test(dataAgentCharles$ENTR, dataAgentCharlesSurrogate$ENTR, paired=FALSE, correct=TRUE)
wilcox.test(dataAgentCharles$L, dataAgentCharlesSurrogate$L, paired=FALSE, correct=TRUE)
wilcox.test(dataAgentCharles$LMAX, dataAgentCharlesSurrogate$LMAX, paired=FALSE, correct=TRUE)
wilcox.test(dataAgentCharles$voc_overlap, dataAgentCharlesSurrogate$voc_overlap, paired=FALSE, correct=TRUE)


## Neg. H-A
wilcox.test(dataNegHA$EV, dataNegHASurrogate$EV, paired=FALSE, correct=TRUE)
wilcox.test(dataNegHA$ER, dataNegHASurrogate$ER, paired=FALSE, correct=TRUE)

wilcox.test(dataNegHA$ENTR, dataNegHASurrogate$ENTR, paired=FALSE, correct=TRUE)
wilcox.test(dataNegHA$L, dataNegHASurrogate$L, paired=FALSE, correct=TRUE)
wilcox.test(dataNegHA$LMAX, dataNegHASurrogate$LMAX, paired=FALSE, correct=TRUE)

wilcox.test(dataNegHA$voc_overlap, dataNegHASurrogate$voc_overlap, paired=FALSE, correct=TRUE)

## Neg. H-H
wilcox.test(dataNegHH$EV, dataNegHHSurrogate$EV, paired=FALSE, correct=TRUE)
wilcox.test(dataNegHH$ER, dataNegHHSurrogate$ER, paired=FALSE, correct=TRUE)

wilcox.test(dataNegHH$ENTR, dataNegHHSurrogate$ENTR, paired=FALSE, correct=TRUE)
wilcox.test(dataNegHH$L, dataNegHHSurrogate$L, paired=FALSE, correct=TRUE)
wilcox.test(dataNegHH$LMAX, dataNegHHSurrogate$LMAX, paired=FALSE, correct=TRUE)
wilcox.test(dataNegHH$voc_overlap, dataNegHHSurrogate$voc_overlap, paired=FALSE, correct=TRUE)
