# LOADING THE DATA
dataNegHA <- read.csv2("Corpora/Corpus_Negotiation_H-A/dial-synthesis.csv", header=TRUE, dec=".", sep="\t")

dataNegHH <- read.csv2("Corpora/Corpus_Negotiation_H-H/dial-synthesis.csv", header=TRUE, dec=".", sep="\t")

dataAgentCharles <- read.csv2("Corpora/Corpus_Alice/dial-synthesis.csv", header=TRUE, dec=".", sep="\t")

colnames(dataNegHA) <- c('ID', 'num_utterances', 'num_tokens', 
                      'ELS', 'EV', 'ER', 
                      'IE_S1', 'ER_S1', 'tokens_S1', 
                      'IE_S2', 'ER_S2', 'tokens_S2', 
                      'voc_overlap', 'voc_overlap_S1', 'voc_overlap_S2',
                      'ENTR', 'L', 'LMAX',
                      'SELS_S1', 'SEV_S1', 'SER_S1', 'SR_ENTR_S1', 'SR_L_S1', 'SR_LMAX_S1',
                      'SELS_S2', 'SEV_S2', 'SER_S2', 'SR_ENTR_S2', 'SR_L_S2', 'SR_LMAX_S2')

colnames(dataNegHH) <- c('ID', 'num_utterances', 'num_tokens', 
                      'ELS', 'EV', 'ER', 
                      'IE_S1', 'ER_S1', 'tokens_S1', 
                      'IE_S2', 'ER_S2', 'tokens_S2', 
                      'voc_overlap', 'voc_overlap_S1', 'voc_overlap_S2',
                      'ENTR', 'L', 'LMAX',                      
                      'SELS_S1', 'SEV_S1', 'SER_S1', 'SR_ENTR_S1', 'SR_L_S1', 'SR_LMAX_S1',
                      'SELS_S2', 'SEV_S2', 'SER_S2', 'SR_ENTR_S2', 'SR_L_S2', 'SR_LMAX_S2')
colnames(dataAgentCharles) <- c('ID', 'num_utterances', 'num_tokens', 
                      'ELS', 'EV', 'ER', 
                      'IE_S1', 'ER_S1', 'tokens_S1', 
                      'IE_S2', 'ER_S2', 'tokens_S2', 
                      'voc_overlap', 'voc_overlap_S1', 'voc_overlap_S2',
                      'ENTR', 'L', 'LMAX',                      
                      'SELS_S1', 'SEV_S1', 'SER_S1',  'SR_ENTR_S1', 'SR_L_S1', 'SR_LMAX_S1',
                      'SELS_S2', 'SEV_S2', 'SER_S2', 'SR_ENTR_S2', 'SR_L_S2', 'SR_LMAX_S2')

# Make sure the data are properly loaded
summary(dataNegHA)
summary(dataNegHH)
summary(dataAgentCharles)

# OFFLINE STUDY
## OTHER-REPETITION
### Nego. H-H VS Nego. H-A
wilcox.test(dataNegHH$EV, dataNegHA$EV, paired=FALSE, correct=TRUE)
wilcox.test(dataNegHH$ER, dataNegHA$ER,  paired=FALSE, correct=TRUE)
wilcox.test(dataNegHH$ENTR, dataNegHA$ENTR,  paired=FALSE, correct=TRUE)
wilcox.test(dataNegHH$L, dataNegHA$L, paired=FALSE,  correct=TRUE)
wilcox.test(dataNegHH$LMAX, dataNegHA$LMAX, paired=FALSE,  correct=TRUE)
wilcox.test(dataNegHH$voc_overlap, dataNegHA$voc_overlap, paired=FALSE,  correct=TRUE)

### Nego. H-H VS Ag. Charles
wilcox.test(dataNegHH$EV, dataAgentCharles$EV, paired=FALSE, correct=TRUE)
wilcox.test(dataNegHH$ER, dataAgentCharles$ER,  paired=FALSE, correct=TRUE)
wilcox.test(dataNegHH$ENTR, dataAgentCharles$ENTR,  paired=FALSE, correct=TRUE)
wilcox.test(dataNegHH$L, dataAgentCharles$L, paired=FALSE,  correct=TRUE)
wilcox.test(dataNegHH$LMAX, dataAgentCharles$LMAX, paired=FALSE,  correct=TRUE)
wilcox.test(dataNegHH$voc_overlap, dataAgentCharles$voc_overlap, paired=FALSE,  correct=TRUE)

### Nego. H-H VS Ag. Charles
wilcox.test(dataNegHA$EV, dataAgentCharles$EV, paired=FALSE, correct=TRUE)
wilcox.test(dataNegHA$ER, dataAgentCharles$ER,  paired=FALSE, correct=TRUE)
wilcox.test(dataNegHA$ENTR, dataAgentCharles$ENTR,  paired=FALSE, correct=TRUE)
wilcox.test(dataNegHA$L, dataAgentCharles$L, paired=FALSE,  correct=TRUE)
wilcox.test(dataNegHA$LMAX, dataAgentCharles$LMAX, paired=FALSE,  correct=TRUE)
wilcox.test(dataNegHA$voc_overlap, dataAgentCharles$voc_overlap, paired=FALSE,  correct=TRUE)

### Nego. H-A
wilcox.test(dataNegHA$IE_S1, dataNegHA$IE_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataNegHA$ER_S1, dataNegHA$ER_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataNegHA$tokens_S1, dataNegHA$tokens_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataNegHA$voc_overlap_S1, dataNegHA$voc_overlap_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataNegHA$SEV_S1, dataNegHA$SEV_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataNegHA$SER_S1, dataNegHA$SER_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataNegHA$SR_ENTR_S1, dataNegHA$SR_ENTR_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataNegHA$SR_L_S1, dataNegHA$SR_L_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataNegHA$SR_LMAX_S1, dataNegHA$SR_LMAX_S2, paired=TRUE, correct=TRUE)

### Ag. Charles
wilcox.test(dataAgentCharles$IE_S1, dataAgentCharles$IE_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataAgentCharles$ER_S1, dataAgentCharles$ER_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataAgentCharles$tokens_S1, dataAgentCharles$tokens_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataAgentCharles$voc_overlap_S1, dataAgentCharles$voc_overlap_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataAgentCharles$SEV_S1, dataAgentCharles$SEV_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataAgentCharles$SER_S1, dataAgentCharles$SER_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataAgentCharles$SR_ENTR_S1, dataAgentCharles$SR_ENTR_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataAgentCharles$SR_L_S1, dataAgentCharles$SR_L_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataAgentCharles$SR_LMAX_S1, dataAgentCharles$SR_LMAX_S2, paired=TRUE, correct=TRUE)

### Nego. H-H
wilcox.test(dataNegHH$IE_S1, dataNegHH$IE_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataNegHH$ER_S1, dataNegHH$ER_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataNegHH$tokens_S1, dataNegHH$tokens_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataNegHH$voc_overlap_S1, dataNegHH$voc_overlap_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataNegHH$SEV_S1, dataNegHH$SEV_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataNegHH$SER_S1, dataNegHH$SER_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataNegHH$SR_ENTR_S1, dataNegHH$SR_ENTR_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataNegHH$SR_L_S1, dataNegHH$SR_L_S2, paired=TRUE, correct=TRUE)
wilcox.test(dataNegHH$SR_LMAX_S1, dataNegHH$SR_LMAX_S2, paired=TRUE, correct=TRUE)

### Entropy (ENTR)
wilcox.test(dataNegHH$ENTR, dataNegHA$ENTR, correct=TRUE)

### L
wilcox.test(dataNegHH$L, dataNegHA$L, correct=TRUE)
wilcox.test(dataNegHH$L, dataAgentCharles$L, correct=TRUE)

### LMAX
wilcox.test(dataNegHH$LMAX, dataNegHA$LMAX, correct=TRUE)

### Initiated Expression (IE_S)
wilcox.test(dataNegHA$IE_S1, dataNegHA$IE_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataAgentCharles$IE_S1, dataAgentCharles$IE_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataNegHH$IE_S1, dataNegHH$IE_S2, paired=TRUE, correct=TRUE)

### Expression Repetition (ER_S)
wilcox.test(dataNegHA$ER_S1, dataNegHA$ER_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataAgentCharles$ER_S1, dataAgentCharles$ER_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataNegHH$ER_S1, dataNegHH$ER_S2, paired=TRUE, correct=TRUE)

### Num. Tokens
wilcox.test(dataNegHA$tokens_S1, dataNegHA$tokens_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataAgentCharles$tokens_S1, dataAgentCharles$tokens_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataNegHH$tokens_S1, dataNegHH$tokens_S2, paired=TRUE, correct=TRUE)

### Voc. Overlap
wilcox.test(dataNegHA$voc_overlap_S1, dataNegHA$voc_overlap_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataAgentCharles$voc_overlap_S1, dataAgentCharles$voc_overlap_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataNegHH$voc_overlap_S1, dataNegHH$voc_overlap_S2, paired=TRUE, correct=TRUE)

## SELF-REPETITION
### Self-Expression Variety (SEV)

wilcox.test(dataNegHA$SEV_S1, dataNegHA$SEV_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataAgentCharles$SEV_S1, dataAgentCharles$SEV_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataNegHH$SEV_S1, dataNegHH$SEV_S2, paired=TRUE, correct=TRUE)

### Self-Expression Repetition (SER)

wilcox.test(dataNegHA$SER_S1, dataNegHA$SER_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataAgentCharles$SER_S1, dataAgentCharles$SER_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataNegHH$SER_S1, dataNegHH$SER_S2, paired=TRUE, correct=TRUE)

### Self-Repetition  ENTR (SR_ENTR_S)
wilcox.test(dataNegHA$SR_ENTR_S1, dataNegHA$SR_ENTR_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataAgentCharles$SR_ENTR_S1, dataAgentCharles$SR_ENTR_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataNegHH$SR_ENTR_S1, dataNegHH$SR_ENTR_S2, paired=TRUE, correct=TRUE)

### Self-Repetition L (SR_L_S)
wilcox.test(dataNegHA$SR_L_S1, dataNegHA$SR_L_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataAgentCharles$SR_L_S1, dataAgentCharles$SR_L_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataNegHH$SR_L_S1, dataNegHH$SR_L_S2, paired=TRUE, correct=TRUE)

### Self-Repetition LMAX (SR_LMAX_S)
wilcox.test(dataNegHA$SR_LMAX_S1, dataNegHA$SR_LMAX_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataAgentCharles$SR_LMAX_S1, dataAgentCharles$SR_LMAX_S2, paired=TRUE, correct=TRUE)

wilcox.test(dataNegHH$SR_LMAX_S1, dataNegHH$SR_LMAX_S2, paired=TRUE, correct=TRUE)
