# LOADING THE DATA
dataNegHA <- read.csv2("Corpora/Corpus_Negotiation_H-A/dial-online.csv", header=FALSE, dec=".", sep="\t")

dataNegHH <- read.csv2("Corpora/Corpus_Negotiation_H-H/dial-online.csv", header=FALSE, dec=".", sep="\t")

dataAgentCharles <- read.csv2("Corpora/Corpus_Alice/dial-online.csv", header=FALSE, dec=".", sep="\t")

colnames(dataNegHA) <- c('dial_name', 'index', 'tokens', 'Locutor', 'SER', 'ER', 'Activation')

colnames(dataNegHH) <- c('dial_name', 'index', 'tokens', 'Locutor', 'SER', 'ER', 'Activation')

colnames(dataAgentCharles) <- c('dial_name', 'index', 'tokens', 'Locutor', 'SER', 'ER', 'Activation')

dataNegHA_A <- dataNegHA[dataNegHA$Locutor == 'A', ]
dataNegHA_B <- dataNegHA[dataNegHA$Locutor == 'B', ]

dataNegHH_A <- dataNegHH[dataNegHH$Locutor == 'a', ]
dataNegHH_B <- dataNegHH[dataNegHH$Locutor == 'b', ]

dataAgentCharles_A <- dataAgentCharles[dataAgentCharles$Locutor == 'A', ]
dataAgentCharles_B <- dataAgentCharles[dataAgentCharles$Locutor == 'B', ]

# Make sure the data are properly loaded
summary(dataNegHA)
summary(dataNegHH)
summary(dataAgentCharles)

# ONLINE STUDY
### Nego. H-A
wilcox.test(dataNegHA_A$ER, dataNegHA_B$ER, correct=TRUE)
wilcox.test(dataNegHA_A$Activation, dataNegHA_B$Activation, correct=TRUE)
wilcox.test(dataNegHA_A$SER, dataNegHA_B$SER, correct=TRUE)

### Ag. Charles
wilcox.test(dataAgentCharles_A$ER, dataAgentCharles_B$ER, correct=TRUE)
wilcox.test(dataAgentCharles_A$Activation, dataAgentCharles_B$Activation, correct=TRUE)
wilcox.test(dataAgentCharles_A$SER, dataAgentCharles_B$SER, correct=TRUE)

### Nego. H-H
wilcox.test(dataNegHH_A$ER, dataNegHH_B$ER, correct=TRUE)
wilcox.test(dataNegHH_A$Activation, dataNegHH_B$Activation, correct=TRUE)
wilcox.test(dataNegHH_A$SER, dataNegHH_B$SER, correct=TRUE)

## SER
wilcox.test(dataNegHA_A$SER, dataNegHA_B$SER, correct=TRUE)

wilcox.test(dataAgentCharles_A$SER, dataAgentCharles_B$SER, correct=TRUE)

wilcox.test(dataNegHH_A$SER, dataNegHH_B$SER, correct=TRUE)

## ER
wilcox.test(dataNegHA_A$ER, dataNegHA_B$ER, correct=TRUE)

wilcox.test(dataAgentCharles_A$ER, dataAgentCharles_B$ER, correct=TRUE)

wilcox.test(dataNegHH_A$ER, dataNegHH_B$ER, correct=TRUE)

## Activation
wilcox.test(dataNegHA_A$Activation, dataNegHA_B$Activation, correct=TRUE)

wilcox.test(dataAgentCharles_A$Activation, dataAgentCharles_B$Activation, correct=TRUE)

wilcox.test(dataNegHH_A$Activation, dataNegHH_B$Activation, correct=TRUE)
